package fr.emse.tb3pwme.todo;

import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.UUID;

@RequestMapping("/api/todos")
@RestController
public class TodoController {

    private final TodoService service;

    public TodoController(TodoService service) {
        this.service = service;
    }

    @GetMapping
    public List<TodoEntity> getAll() {
        return service.getAll();
    }

    @GetMapping("/{id}")
    public TodoEntity getById(@PathVariable UUID id) {
        return service.getById(id);
    }

    @PostMapping
    @ResponseStatus(HttpStatus.CREATED)
    public TodoEntity create(@RequestBody CreateTodoRequest request) {
        return service.create(request.getDescription());
    }

    @PutMapping("/{id}")
    public TodoEntity update(@PathVariable UUID id, @RequestBody CreateTodoRequest request) {
        return service.update(id, request.getDescription());
    }

    @DeleteMapping("/{id}")
    @ResponseStatus(HttpStatus.NO_CONTENT)
    public void delete(@PathVariable UUID id) {
        service.delete(id);
    }

    public static class CreateTodoRequest {

        private String description;

        public String getDescription() {
            return description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

    }
}

