package fr.emse.tb3pwme.todo;

import org.springframework.stereotype.Service;

import java.util.List;
import java.util.UUID;

@Service
public class TodoService {

    private TodoRepository repository;

    public TodoService(TodoRepository repository) {
        this.repository = repository;
    }

    public List<TodoEntity> getAll() {
        return repository.findAll();
    }

    public TodoEntity getById(UUID id) {
        return repository.findById(id)
                .orElseThrow(() -> new RuntimeException("Todo not found"));
    }

    public TodoEntity create(String description) {
        TodoEntity todo = new TodoEntity();
        todo.setId(UUID.randomUUID());
        todo.setDescription(description);
        return repository.save(todo);
    }

    public TodoEntity update(UUID id, String description) {
        TodoEntity todo = getById(id);
        todo.setDescription(description);
        return repository.save(todo);
    }

    public void delete(UUID id) {
        repository.deleteById(id);
    }

}
