package fr.emse.tb3pwme.todo

import androidx.compose.runtime.Composable
import androidx.navigation.NavType
import androidx.navigation.compose.NavHost
import androidx.navigation.compose.composable
import androidx.navigation.compose.rememberNavController
import androidx.navigation.navArgument

sealed class Screen(val route: String) {
    object TodoList : Screen("todo_list")
    object TodoDetail : Screen("todo_detail/{todoId}") {
        fun createRoute(todoId: String) = "todo_detail/$todoId"
    }
}

@Composable
fun TodoNavGraph(viewModel: TodosViewModel) {
    val navController = rememberNavController()

    NavHost(navController, startDestination = Screen.TodoList.route) {
        composable(Screen.TodoList.route) {
            TodoListScreen(
                viewModel = viewModel,
                onAdd = { navController.navigate(Screen.TodoDetail.createRoute("new")) },
                onEdit = { todo -> navController.navigate(Screen.TodoDetail.createRoute(todo.id.toString())) }
            )
        }

        composable(
            route = Screen.TodoDetail.route,
            arguments = listOf(navArgument("todoId") { type = NavType.StringType })
        ) { backStackEntry ->
            val todoIdArg = backStackEntry.arguments?.getString("todoId")!!
            TodoDetailScreen(
                todoIdArg = todoIdArg,
                viewModel = viewModel,
                onDone = { navController.popBackStack() }
            )
        }
    }
}