package fr.emse.tb3pwme.todo

import com.squareup.moshi.Moshi
import com.squareup.moshi.kotlin.reflect.KotlinJsonAdapterFactory
import retrofit2.Retrofit
import retrofit2.converter.moshi.MoshiConverterFactory
import retrofit2.http.*
import java.util.UUID

interface TodoApi {

    @GET("/api/todos")
    suspend fun getTodos(): List<Todo>

    @POST("/api/todos")
    suspend fun createTodo(@Body request: CreateTodoRequest): Todo

    @PUT("/api/todos/{id}")
    suspend fun updateTodo(@Path("id") id: UUID, @Body request: CreateTodoRequest): Todo

    @DELETE("/api/todos/{id}")
    suspend fun deleteTodo(@Path("id") id: UUID)

}

object RetrofitProvider {

    private const val BASE_URL = "http://10.0.2.2:8080/"

    val moshi = Moshi.Builder()
        .add(UUID::class.java, UUIDAdapter())
        .addLast(KotlinJsonAdapterFactory())
        .build()

    val api: TodoApi by lazy {
        Retrofit.Builder()
            .baseUrl(BASE_URL)
            .addConverterFactory(MoshiConverterFactory.create(moshi))
            // .addConverterFactory(MoshiConverterFactory.create())
            .build()
            .create(TodoApi::class.java)
    }

}
