package fr.emse.tb3pwme.todo

import androidx.compose.foundation.layout.*
import androidx.compose.material3.*
import androidx.compose.runtime.*
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import java.util.UUID

@Composable
fun TodoDetailScreen(
    todoIdArg: String,
    viewModel: TodosViewModel,
    onDone: () -> Unit
) {
    var description by remember { mutableStateOf("") }
    val isNew = todoIdArg == "new"
    val todoId = if (isNew) null else UUID.fromString(todoIdArg)

    LaunchedEffect(todoId) {
        if (!isNew && todoId != null) {
            val todo = viewModel.todos.value.find { it.id == todoId }
            description = todo?.description ?: ""
        }
    }

    Scaffold { padding ->
        Column(modifier = Modifier
            .padding(16.dp)
            .fillMaxWidth()
        ) {
            OutlinedTextField(
                value = description,
                onValueChange = { description = it },
                label = { Text("Description") },
                modifier = Modifier.fillMaxWidth()
            )
            Spacer(modifier = Modifier.height(16.dp))
            Button(
                onClick = {
                    if (isNew) {
                        viewModel.createTodo(description, onDone)
                    } else {
                        todoId?.let { viewModel.updateTodo(it, description, onDone) }
                    }
                },
                modifier = Modifier.fillMaxWidth()
            ) {
                Text(if (isNew) "Create" else "Save")
            }
        }
    }
}
