package fr.emse.tb3pwme.todo

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.launch
import java.util.UUID

class TodosViewModel : ViewModel() {

    private val api = RetrofitProvider.api

    private val _todos = MutableStateFlow<List<Todo>>(emptyList())
    val todos: StateFlow<List<Todo>> = _todos

    init {
        loadTodos()
    }

    fun loadTodos() {
        viewModelScope.launch {
            _todos.value = api.getTodos()
        }
    }

    fun createTodo(description: String, onComplete: () -> Unit) {
        viewModelScope.launch {
            api.createTodo(CreateTodoRequest(description))
            loadTodos()
            onComplete()
        }
    }

    fun updateTodo(id: UUID, description: String, onComplete: () -> Unit) {
        viewModelScope.launch {
            api.updateTodo(id, CreateTodoRequest(description))
            loadTodos()
            onComplete()
        }
    }

    fun deleteTodo(id: UUID) {
        viewModelScope.launch {
            api.deleteTodo(id)
            loadTodos()
        }
    }

}
