package fr.emse.tb3pwme.todo

import com.squareup.moshi.JsonAdapter
import java.util.UUID

class UUIDAdapter : JsonAdapter<UUID>() {

    override fun fromJson(reader: com.squareup.moshi.JsonReader): UUID? {
        val string = reader.nextString()
        return UUID.fromString(string)
    }

    override fun toJson(writer: com.squareup.moshi.JsonWriter, value: UUID?) {
        writer.value(value?.toString())
    }

}
